/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';
export type CompareDateCallback = () => string | Date;

export interface DateOptions extends ValidateOptions {
    // The date format. Default is MM/DD/YYYY
    // The format can be:
    // - date: Consist of DD, MM, YYYY parts which are separated by the separator option
    // - date and time: The time can consist of h, m, s parts which are separated by :
    // - date, time and A (indicating AM or PM)
    format: string;
    // The maximum date
    max?: string | Date | CompareDateCallback;
    // The minimum date
    min?: string | Date | CompareDateCallback;
    // Use to separate the date, month, and year. By default, it is /
    separator?: string;
}
export interface DateLocalization extends Localization {
    date: {
        default: string;
        max: string;
        min: string;
        range: string;
    };
}

export function date(): ValidateFunctionInterface<DateOptions, ValidateResult>;
