<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use LaravelLegends\EloquentFilter\Concerns\HasFilter;

class Ticket extends Model
{
    use HasFilter;
    use SoftDeletes;
    protected $fillable = [
        'title',
        'description',
        'status',
        'priority',
        'employee_id',
        'assigned_to',
        'escalated_to',
        'product_id',
        'file_path',
    ];
    public function employee()
    {
        return $this->belongsTo(User::class, 'employee_id');
    }

    public function assignedTo()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    public function escalatedTo()
    {
        return $this->belongsTo(User::class, 'escalated_to');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function comments()
    {
        return $this->hasMany(Comment::class);
    }

    public function attachments()
    {
        return $this->hasMany(Attachment::class);
    }
}
