<?php

namespace App\Http\Controllers\pages;

use App\Http\Controllers\Controller;
use App\Models\Ticket;
use Illuminate\Http\Request;

class HomePage extends Controller
{
  public function index()
  {
    $totalTickets = Ticket::count();
    $openTickets = Ticket::where('status', 'open')->count();
    $closedTickets = Ticket::where('status', 'closed')->count();
    $openTicketsList = Ticket::where('status', 'open')->latest()->take(10)->get();
    return view('content.pages.pages-home', compact('totalTickets', 'openTickets', 'closedTickets', 'openTicketsList'));
  }
}
