<?php

namespace App\Http\Controllers\authentications;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class RegisterBasic extends Controller
{
  public function index()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('content.authentications.auth-register-basic', ['pageConfigs' => $pageConfigs]);
  }

  public function register(UserRequest $request)
  {
    $validated = $request->validated();
    // Handle the file upload
    if($request->hasFile('photo')) $validated['photo_path'] = $request->file('photo')->store('photos', 'public');
    $validated['role'] = 'employee';
    // Create a new user
    User::create($validated);

    return redirect()->route('login')->with('success', 'تم تسجيل الحساب بنجاح');
  }
}
