<?php

namespace App\Http\Controllers\authentications;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginBasic extends Controller
{
  public function index()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('content.authentications.auth-login-basic', ['pageConfigs' => $pageConfigs]);
  }

  public function login(Request $request)
  {
    $request->validate([
      'phone_number' => 'required',
      'password' => 'required',
    ]);

    if (Auth::attempt($request->only('phone_number', 'password'))) {
      $request->session()->regenerate();

      return redirect()->intended('/')->with('success', 'تم تسجيل الدخول بنجاح.');
    }

    return back()->withErrors([
      'phone_number' => 'بيانات الاعتماد المقدمة لا تتطابق مع سجلاتنا.',
    ]);
  }

  public function logout(Request $request)
  {
    Auth::logout();

    $request->session()->invalidate();
    $request->session()->regenerateToken();

    return redirect('/auth/login')->with('success', 'تم تسجيل الخروج بنجاح.');
  }
}
