<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;

class UserController extends Controller
{
    public function index()
    {
        $users = User::all();
        return view('content.pages.users.index', compact('users'));
    }

    public function create()
    {
        return view('content.pages.users.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'phone_number' => 'required|string|unique:users',
            'department' => 'nullable|in:Customer Service,Operations,Sales and Marketing',
            'photo_path' => 'nullable|image|max:2048',
            'password' => 'required|string|min:8|confirmed',
        ]);

        $data = $request->all();
        $data['password'] = bcrypt($request->password);

        if ($request->hasFile('photo_path')) {
            $data['photo_path'] = $request->file('photo_path')->store('users', 'public');
        }

        User::create($data);

        return redirect()->route('users.index')->with('success', 'User created successfully.');
    }

    public function show(User $user)
    {
        return view('content.pages.users.show', compact('user'));
    }

    public function edit(User $user)
    {
        return view('content.pages.users.edit', compact('user'));
    }

    public function update(Request $request, User $user)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users,email,' . $user->id,
            'phone_number' => 'required|string|unique:users,phone_number,' . $user->id,
            'department' => 'nullable|in:Customer Service,Operations,Sales and Marketing',
            'photo_path' => 'nullable|image|max:2048',
        ]);

        $data = $request->all();
        $data['role']= 'employee';
        if ($request->hasFile('photo_path')) {
            $data['photo_path'] = $request->file('photo_path')->store('users', 'public');
        }

        $user->update($data);

        return redirect()->route('users.index')->with('success', 'User updated successfully.');
    }

    public function destroy(User $user)
    {
        $user->delete();
        return redirect()->route('users.index')->with('success', 'User deleted successfully.');
    }
}
